/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public abstract class AbstractMaterialRenderInfoProvider
extends GenericDataProvider {
    private final Map<MaterialVariantId, RenderInfoBuilder> allRenderInfo = new HashMap<MaterialVariantId, RenderInfoBuilder>();
    @Nullable
    private final AbstractMaterialSpriteProvider materialSprites;

    public AbstractMaterialRenderInfoProvider(FabricDataOutput output, @Nullable AbstractMaterialSpriteProvider materialSprites) {
        super(output, class_3264.field_14188, "tinkering/materials", MaterialRenderInfoLoader.GSON);
        this.materialSprites = materialSprites;
    }

    public AbstractMaterialRenderInfoProvider(FabricDataOutput output) {
        this(output, (AbstractMaterialSpriteProvider)null);
    }

    protected abstract void addMaterialRenderInfo();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addMaterialRenderInfo();
        ArrayList futures = new ArrayList();
        this.allRenderInfo.forEach((materialId, info) -> futures.add(this.saveThing(cache, materialId.getLocation('/'), info.build())));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private RenderInfoBuilder getBuilder(class_2960 texture) {
        AbstractMaterialSpriteProvider.MaterialSpriteInfo spriteInfo;
        RenderInfoBuilder builder = new RenderInfoBuilder();
        if (this.materialSprites != null && (spriteInfo = this.materialSprites.getMaterialInfo(texture)) != null) {
            int color;
            String[] fallbacks = spriteInfo.getFallbacks();
            if (fallbacks.length > 0) {
                builder.fallbacks(fallbacks);
            }
            if ((color = spriteInfo.getTransformer().getFallbackColor()) != -1) {
                builder.color(color & 0xFF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000);
            }
            builder.generator(spriteInfo);
        }
        return builder;
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialVariantId materialId) {
        return this.allRenderInfo.computeIfAbsent(materialId, id -> this.getBuilder(materialId.getLocation('_')));
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialVariantId materialId, class_2960 texture) {
        return this.allRenderInfo.computeIfAbsent(materialId, id -> this.getBuilder(texture).texture(texture));
    }

    protected static class RenderInfoBuilder {
        private class_2960 texture = null;
        private String[] fallbacks;
        private int color = -1;
        private boolean skipUniqueTexture;
        private int luminosity = 0;
        private MaterialRenderInfoJson.MaterialGeneratorJson generator = null;

        protected RenderInfoBuilder() {
        }

        public RenderInfoBuilder fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
            return this;
        }

        public RenderInfoBuilder materialTexture(MaterialVariantId variantId) {
            return this.texture(variantId.getLocation('_'));
        }

        public MaterialRenderInfoJson build() {
            return new MaterialRenderInfoJson(this.texture, this.fallbacks, String.format("%06X", this.color), this.skipUniqueTexture ? Boolean.TRUE : null, this.luminosity, this.generator);
        }

        public RenderInfoBuilder texture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public RenderInfoBuilder color(int color) {
            this.color = color;
            return this;
        }

        public RenderInfoBuilder skipUniqueTexture(boolean skipUniqueTexture) {
            this.skipUniqueTexture = skipUniqueTexture;
            return this;
        }

        public RenderInfoBuilder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public RenderInfoBuilder generator(MaterialRenderInfoJson.MaterialGeneratorJson generator) {
            this.generator = generator;
            return this;
        }
    }
}

